require 'rubygems'
require 'oci8'
require 'bigdecimal'
require 'bigdecimal/util'
require_relative '../../module/DateUtility'
require_relative '../../spec/rspec_helper'

module OracleUtility
  include DateUtility
  @@patientID ="1113138327"

  def executeQuery(sql)
    begin
      puts "executeQuery() Begin"
      puts "sql = " + sql
      conn = OCI8.new(ORACLE_USER, ORACLE_PASSWORD, ORACLE_VAMF_HOST_PORT + '/' + ORACLE_SERVICE_NAME)
      conn.exec(sql)
      conn.commit
      conn.logoff
        #puts ("executeQuery() End")
    rescue Exception => e
      puts "[ExcuteQuery() Exception ]" + e.message
    end
  end

  def executeAndGetDataAndNumRow(sql)
    puts "executeAndgetNumRowAndData() Begin"
    conn = OCI8.new(ORACLE_USER, ORACLE_PASSWORD, ORACLE_VAMF_HOST_PORT + '/' + ORACLE_SERVICE_NAME)
    returnedData = ''

    num_rows = conn.exec(sql) do |r|

      returnedData = r.join(',')
    end

    puts ("num row is " + num_rows.to_s)

    puts "[returned value] " + returnedData.to_s
    conn.commit
    conn.logoff

    puts "executeAndgetNumRowAndData() End"
    return returnedData + "||" + num_rows.to_s
  end

  def deleteUserFromRightOfAccess(patientId)
    executeQuery("DELETE FROM HADB.USER_RIGHTOFACCESS WHERE USER_ID='" + patientId + "'")
    puts "Deleted ROA for UserID=" + patientId
  end

  def setDefaultROAForPatient(patientId)

    begin

    conn =OCI8.new(ORACLE_USER, ORACLE_PASSWORD, ORACLE_VAMF_HOST_PORT + "/" + ORACLE_SERVICE_NAME)

    num_rows = conn.exec("SELECT * FROM HADB.USER_RIGHTOFACCESS WHERE USER_ID='" + patientId + "'") do |r|
        puts r.join(',')
    end

    puts ("num row is " + num_rows.to_s)

    if num_rows == nil  || num_rows == 0 then
      conn.exec("INSERT INTO HADB.USER_RIGHTOFACCESS (USER_ID, ROA_STATE, ROA_DATE, ROA_FORM) VALUES ('" + patientId + "', TO_NUMBER(1), TO_DATE('2015/05/31', 'YYYY/MM/DD'), utl_raw.cast_to_raw('empty'))")

    end

    conn.commit
    conn.logoff

    puts "[setDefaultROAForPatient]"

    rescue Exception => e
    puts "[ExcuteQuery() Exception ]" + e.message
    end

  end

  def updateStatus(appmt_request_id, patient_id, status, appointment_type)
    sql = "update VARDB.appointment_request set status ='" + status + "' where PATIENT_ID='" + patient_id + "' and appointment_request_id ='" + appmt_request_id + "' and appointment_type='" + appointment_type + "'"
    executeQuery(sql)
  end

  def updateAppointmentRequestedFields(date, option_date_time1, option_date_time2, option_date_time3, patient_id, appmt_request_id, status)
    sql = "update VARDB.appointment_request set Last_Updated_Date=to_date('" + date + "', 'MM/DD/YYYY'), Created_Date=to_date('" + date + "', 'MM/DD/YYYY'), Option_date_1='" +option_date_time1[0] + "', option_time_1='" + option_date_time1[1] +"', option_date_2='" + option_date_time2[0] + "', option_time_2='" + option_date_time2[1] +"', option_date_3='" + option_date_time3[0]+ "', option_time_3='" + option_date_time3[1] + "', phone_number='(123) 456-7890', status='" + status + "' where PATIENT_ID='" + patient_id + "' and appointment_request_id ='" + appmt_request_id + "'"
    executeQuery(sql)
  end

  def updateAppointmentRequestedPreference(provider_option, purpose_of_visit, other_purpose_of_visit, patient_id, appmt_request_id)
    sql = "update VARDB.appointment_request set provider_option='" + provider_option + "', purpose_of_visit='" + purpose_of_visit+ "', other_purpose_of_visit='" + other_purpose_of_visit +"' where PATIENT_ID='" + patient_id + "' and appointment_request_id ='" + appmt_request_id + "'"
    executeQuery(sql)
  end

  def deleteMessage(patientId, apmt_rqt_id)
    sql = "delete from vardb.appointment_request_message where sender_id='" + patientId +  "' and appointment_request_id='" + apmt_rqt_id +"'"
    executeQuery(sql)

    sql2 =  "delete from vardb.appointment_request_message  where sender_id='staffscv' and appointment_request_id='" + apmt_rqt_id +"'"
    executeQuery(sql)
  end


  def getLastUpdatedFromDB(patient_id, appmt_request_id)
    sql = "select last_updated_date from vardb.appointment_request where patient_id='" + patient_id + "' and appointment_request_id='" + appmt_request_id + "'"
    returnedData = executeAndGetDataAndNumRow(sql)

    dateArr = returnedData.split("||")
    dateHHMM = dateArr[0].split(" -")

    return getFormatedDateStr(dateHHMM[0], "%Y-%m-%d %H:%M", "%m/%d/%Y %H:%M")
  end

  def resetDataForPatientOne()
    executeQuery( "delete from vardb.best_time_to_call where appointment_request_id in (select appointment_request_id from vardb.appointment_request where patient_id ='P001' and appointment_request_id not in('00000000000000000000000000000013', '00000000000000000000000000000014','00000000000000000000000000000015', '00000000000000000000000000000016', '00000000000000000000000000000017'))")
    executeQuery("delete from vardb.notification_preference where patient_id ='P001'")
    executeQuery("delete from vardb.ar_detail_code where user_id='P001'")
    #executeQuery("delete from vardb.appointment_request_message where appointment_request_id not in('00000000000000000000000000000013', '00000000000000000000000000000014','00000000000000000000000000000015', '00000000000000000000000000000016', '00000000000000000000000000000017')" )

    executeQuery("delete from vardb.appointment_request_message where sender_id='P001'")
    executeQuery("delete from vardb.appointment_request where patient_id ='P001' and appointment_request_id not in('00000000000000000000000000000013', '00000000000000000000000000000014','00000000000000000000000000000015', '00000000000000000000000000000016', '00000000000000000000000000000017')")
  end

  def deletePatientData(patientId)
    executeQuery("delete from vardb.best_time_to_call where appointment_request_id in (select appointment_request_id from vardb.appointment_request where patient_id ='" + patientId + "')")
    executeQuery("delete from vardb.notification_preference where patient_id ='" + patientId + "'")
    executeQuery("delete from vardb.ar_detail_code where appointment_request_id in (select appointment_request_id from vardb.appointment_request where patient_id ='" + patientId + "')")
    executeQuery("delete from vardb.appointment_request_message where sender_id='" + patientId +  "'")
    executeQuery("delete from vardb.appointment_request where patient_id ='" + patientId + "'")
  end

  def deleteAllRequestData()
    executeQuery("delete from vardb.best_time_to_call")
    executeQuery("delete from vardb.notification_preference")
    executeQuery("delete from vardb.ar_detail_code")
    executeQuery("delete from vardb.appointment_request_message")
    executeQuery("delete from vardb.appointment_request")
    executeQuery("delete from vardb.APPT_REQ_INPROCESS")
  end

  def deleteAllCCRequestData()
    executeQuery("delete from vardb.best_time_to_call")
    executeQuery("delete from vardb.ar_detail_code")
    executeQuery("delete from vardb.appointment_request_message")
    executeQuery("delete from vardb.appointment_request")
    executeQuery("delete from vardb.APPT_REQ_INPROCESS")
    executeQuery("delete from vardb.OFFICE_HOURS")
    executeQuery("delete from vardb.PREFERRED_PROVIDER")
    executeQuery("delete from vardb.CC_APPOINTMENT_REQUEST")
  end

  def deleteNotificationPreference(patientId)
    executeQuery("delete from vardb.notification_preference where patient_id ='" + patientId + "'")
  end

  def insertRequestsData(status, typeOfCare, facility_id, typeOfCareID, friendly_name, detcode)
    $today = getDateNthDaysFromNow(0, "%m/%d/%Y")
    $two_days_later = getDateNthDaysFromNow(2, "%m/%d/%Y")
    $futureDate = getDateNthDaysFromNow(4, "%m/%d/%Y")
    $detcodeID;
    $detcode;
    puts "Inserting requests....."
    case detcode
      when "DETCODE24"
        $detcodeID = "8a828284622a3cf3016230216b640046"
        $detcode = "DETCODE24"
        puts "DETCODE24"
      when "DETCODE23"
        $detcodeID = "8a828284622a3cf301623020fa5c0041"
        $detcode = "DETCODE23"
        puts "DETCODE23"
      when "DETCODE22"
        $detcodeID = "8a828284622a3cf301623020a84c003a"
        $detcode = "DETCODE22"
        puts "DETCODE22"
      when "DETCODE21"
        $detcodeID = "8a828284622a3cf301623020124a0032"
        $detcode = "DETCODE21"
        puts "DETCODE21"
      when "DETCODE20"
        $detcodeID = "8a828284622a3cf301622a6bd84e001f"
        $detcode = "DETCODE20"
        puts "DETCODE20"
      else
        puts "DETCODE is undefined"
    end
    sql =<<EOF
      INSERT INTO "VARDB"."APPOINTMENT_REQUEST" (APPOINTMENT_REQUEST_ID,PATIENT_ID,LAST_UPDATED_DATE,CREATED_DATE,DELETED_DATE,ACTIVE,SECOND_REQUEST,APPOINTMENT_DATE,APPOINTMENT_TIME,OPTION_DATE_1,OPTION_TIME_1,OPTION_DATE_2,OPTION_TIME_2,OPTION_DATE_3,OPTION_TIME_3,STATUS,APPOINTMENT_TYPE,FACILITY_CODE,EMAIL,PHONE_NUMBER,TEXT_MESSAGING_ALLOWED,TEXT_MESSAGING_PHONE_NUMBER,PURPOSE_OF_VISIT,OTHER_PURPOSE_OF_VISIT,VISIT_TYPE,PROVIDER_ID,PROVIDER_NAME,PROVIDER_PERSON_CLASS,PROVIDER_OPTION,SECOND_REQUEST_SUBMITTED,PARENT_REQUEST_ID,HAS_VETERAN_NEW_MESSAGE,HAS_PROVIDER_NEW_MESSAGE,PROVIDER_SEEN_APPT_REQ,REQUESTED_PHONE_CALL,TYPE_OF_CARE_ID,REASON_FOR_VISIT,OTHER_REASON_FOR_VISIT,ADDITIONAL_INFORMATION,BOOKED_APPT_DATETIME,FRIENDLY_NAME) values ('8a8282845ee822ad015ee839f7130005','#{@@patientID}',to_timestamp('#{getDateNthDaysFromNow(0, "%d-%b-%y")} 12.31.06.481000000 PM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('#{getDateNthDaysFromNow(0, "%d-%b-%y")} 12.31.06.481000000 PM','DD-MON-RR HH.MI.SSXFF AM'),null,1,0,null,null,'#{getDateNthDaysFromNow(2, "%m/%d/%Y")}','AM','No Date Selected','No Time Selected','No Date Selected','No Time Selected','#{status}','#{typeOfCare}','#{facility_id}','test@test.com','(234) 567-8900',0,null,'New Issue',null,'Office Visit','0',null,null,null,0,null,0,0,0,1,'#{typeOfCareID}',null,null,'test request',null,'#{friendly_name}');
      INSERT INTO "VARDB"."BEST_TIME_TO_CALL" (APPOINTMENT_REQUEST_ID,BEST_TIME) values ('8a8282845ee822ad015ee839f7130005', 'Morning');
      INSERT INTO "VARDB"."AR_DETAIL_CODE" (AR_DETAIL_CODE_ID,DETAIL_CODE_ID,APPOINTMENT_REQUEST_ID,CREATED_DATE,USER_ID) values ('#{$detcodeID}','#{$detcode}','8a8282845ee822ad015ee839f7130005',to_timestamp('#{getDateNthDaysFromNow(0, "%d-%b-%y")} 11.29.13.801000000 AM','DD-MON-RR HH.MI.SSXFF AM'),'990');
  COMMIT;
EOF
    insertRequest(sql)
    puts "requests inserted"
    datex = "#{getDateNthDaysFromNow(0, "%d-%b-%y")} 11.29.13.801000000 AM"
    puts $detcodeID
    puts $detcode
    puts datex
  end

  def insertFacilityData()
    sql=<<EOF
    Insert into "VARDB"."FACILITY" (NAME,TYPE,FACILITY_CODE,STATE,CITY,ADDRESS,PARENT_SITE_CODE) values ('DC VAMC','VAMC','688','DC','Washington','50 Irving St. NW Washington, DC 20422','688');
    Insert into "VARDB"."FACILITY" (NAME,TYPE,FACILITY_CODE,STATE,CITY,ADDRESS,PARENT_SITE_CODE) values ('TEST VAMC 3','VAMC','777','VA','Chantilly','5154 Parkstone Dr\nChantilly, VA 20120','777');
    Insert into "VARDB"."FACILITY" (NAME,TYPE,FACILITY_CODE,STATE,CITY,ADDRESS,PARENT_SITE_CODE) values ('BAY PINES VA HCS','VAMC','516','FL','BAY PINES','10000 BAY PINES BLVD','516');
    Insert into "VARDB"."FACILITY" (NAME,TYPE,FACILITY_CODE,STATE,CITY,ADDRESS,PARENT_SITE_CODE) values ('BOSTON HCS VAMC',null,'523','MA','BOSTON',null,'523');
    Insert into "VARDB"."FACILITY" (NAME,TYPE,FACILITY_CODE,STATE,CITY,ADDRESS,PARENT_SITE_CODE) values ('VA CNTRL WSTRN MASSCHUSETS HCS','VAMC','631','MA','LEEDS','421 NORTH MAIN STREET','631');
    Insert into "VARDB"."FACILITY" (NAME,TYPE,FACILITY_CODE,STATE,CITY,ADDRESS,PARENT_SITE_CODE) values ('MILWAUKEE VAMC','VAMC','695','WI','MILWAUKEE','150 SOUTH HUNTINGTON AVENUE','695');
    Insert into "VARDB"."FACILITY" (NAME,TYPE,FACILITY_CODE,STATE,CITY,ADDRESS,PARENT_SITE_CODE) values ('CHELSEA',null,'523DT',null,null,null,'523');
    Insert into "VARDB"."FACILITY" (NAME,TYPE,FACILITY_CODE,STATE,CITY,ADDRESS,PARENT_SITE_CODE) values ('FRAMINGHAM',null,'523GA',null,null,null,'523');
    Insert into "VARDB"."FACILITY" (NAME,TYPE,FACILITY_CODE,STATE,CITY,ADDRESS,PARENT_SITE_CODE) values ('BOSTON SOC',null,'523BZ',null,null,null,'523');
    Insert into "VARDB"."FACILITY" (NAME,TYPE,FACILITY_CODE,STATE,CITY,ADDRESS,PARENT_SITE_CODE) values ('QUINCY',null,'523GC',null,null,null,'523');
    Insert into "VARDB"."FACILITY" (NAME,TYPE,FACILITY_CODE,STATE,CITY,ADDRESS,PARENT_SITE_CODE) values ('PLYMOUTH CBOC',null,'523GD',null,null,null,'523');
    Insert into "VARDB"."FACILITY" (NAME,TYPE,FACILITY_CODE,STATE,CITY,ADDRESS,PARENT_SITE_CODE) values ('BOSTON PRRTP',null,'523PA',null,null,null,'523');
    Insert into "VARDB"."FACILITY" (NAME,TYPE,FACILITY_CODE,STATE,CITY,ADDRESS,PARENT_SITE_CODE) values ('BROCKTON VAMC',null,'523A5','MA','BROCKTON',null,'523');
    Insert into "VARDB"."FACILITY" (NAME,TYPE,FACILITY_CODE,STATE,CITY,ADDRESS,PARENT_SITE_CODE) values ('VA NWIHS, OMAHA DIVISION','VAMC','636','NE','OMAHA','4101 WOOLWORTH AVE.','636');
  COMMIT;
EOF
    insertRequest(sql)
  end

  def updateAppointmentRequestedLastUpdatedDate(date, patient_id, appmt_type, status)
    sql = "update VARDB.appointment_request set Last_Updated_Date=to_date('" + date + "', 'YYYY-MM-DD'), Created_Date=to_date('" + date + "', 'YYYY-MM-DD'), status='" + status + "' where PATIENT_ID='" + patient_id + "' and appointment_type ='" + appmt_type + "'"
    executeQuery(sql)
  end

  def insertRequest(sql)
    sql = sql.split(';')
    sql.each do |query|
      query.strip!
      executeQuery(query) unless query.empty?
    end

  end


end
